<?php
/**
 * The Ajax powered instant response page.
 * 
 * PHP Version 5.2
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * @category  phpMyFAQ
 * @package   Frontend
 * @author    Thorsten Rinne <thorsten@phpmyfaq.de>
 * @author    Matteo Scaramuccia <matteo@phpmyfaq.de>
 * @copyright 2007-2010 phpMyFAQ Team
 * @license   http://www.mozilla.org/MPL/MPL-1.1.html Mozilla Public License Version 1.1
 * @link      http://www.phpmyfaq.de
 * @since     2007-03-18
 */

if (!defined('IS_VALID_PHPMYFAQ')) {
    header('Location: http://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['SCRIPT_NAME']));
    exit();
}

$faqsession->userTracking('instantresponse', 0);

$searchString = $printInstantResponse = '';

	if ($faqconfig->get('main.enableRewriteRules')) {

	$tpl->processTemplate('writeContent', array(

	'msgInstantResponse'            => $PMF_LANG['msgInstantResponse'],
	'msgDescriptionInstantResponse' => $PMF_LANG['msgDescriptionInstantResponse'],
	'searchString'                  => $searchString,
	'writeSendAdress'               => '?'.$sids.'action=instantresponse',
	'ajaxlanguage'                  => $LANGCODE,
	'msgSearchWord'                 => $PMF_LANG['msgSearchWord'],
	'printInstantResponse'          => $printInstantResponse,

	"linkfaqHome"                   => $faqconfig->get('main.referenceURL'),
	"linkmsgSearch"                 => '<a href="' . $systemUri . 'search.html">'.$PMF_LANG["msgAdvancedSearch"].'</a>',
	'linkmsgAddContent'             => '<a href="' . $systemUri . 'addcontent.html">'.$PMF_LANG["msgAddContent"].'</a>',
	"linkmsgQuestion"               => '<a href="' . $systemUri . 'ask.html">'.$PMF_LANG["msgQuestion"].'</a>',
	"linkmsgOpenQuestions"          => '<a href="' . $systemUri . 'open.html">'.$PMF_LANG["msgOpenQuestions"].'</a>',
	'linkmsgHelp'                   => '<a href="' . $systemUri . 'help.html">'.$PMF_LANG["msgHelp"].'</a>',
	"linkmsgContact"                => '<a href="' . $systemUri . 'contact.html">'.$PMF_LANG["msgContact"].'</a>',
	"linkbackToHome"                => '<a href="' . $systemUri . 'index.html">'.$PMF_LANG["msgHome"].'</a>',
	"linkallCategories"             => '<a href="' . $systemUri . 'showcat.html">'.$PMF_LANG["msgShowAllCategories"].'</a>',
	'linkshowInstantResponse'       => '<a href="' . $systemUri . 'instantresponse.html">'.$PMF_LANG['msgInstantResponse'].'</a>',
	'linkshowSitemap'               => '<a href="' . $systemUri . 'sitemap/A/'.$LANGCODE.'.html">'.$PMF_LANG['msgSitemap'].'</a>',
	'linkopensearch'                => $systemUri . 'opensearch.html',
	
	));
	
	}
	
	else {
	
	$tpl->processTemplate('writeContent', array(

	'msgInstantResponse'            => $PMF_LANG['msgInstantResponse'],
	'msgDescriptionInstantResponse' => $PMF_LANG['msgDescriptionInstantResponse'],
	'searchString'                  => $searchString,
	'writeSendAdress'               => '?'.$sids.'action=instantresponse',
	'ajaxlanguage'                  => $LANGCODE,
	'msgSearchWord'                 => $PMF_LANG['msgSearchWord'],
	'printInstantResponse'          => $printInstantResponse,

	"linkfaqHome"                   => $faqconfig->get('main.referenceURL'),
	"linkmsgSearch"                 => '<a href="index.php?'.$sids.'action=search">'.$PMF_LANG["msgAdvancedSearch"].'</a>',
	"linkmsgAddContent"             => '<a href="index.php?'.$sids.'action=add">'.$PMF_LANG["msgAddContent"].'</a>',
	"linkmsgQuestion"               => '<a href="index.php?'.$sids.'action=ask">'.$PMF_LANG["msgQuestion"].'</a>',
	"linkmsgOpenQuestions"          => '<a href="index.php?'.$sids.'action=open">'.$PMF_LANG["msgOpenQuestions"].'</a>',
	"linkmsgHelp"                   => '<a href="index.php?'.$sids.'action=help">'.$PMF_LANG["msgHelp"].'</a>',
	"linkmsgContact"                => '<a href="index.php?'.$sids.'action=contact">'.$PMF_LANG["msgContact"].'</a>',
	"linkallCategories"             => '<a href="index.php?'.$sids.'action=show">'.$PMF_LANG["msgShowAllCategories"].'</a>',
	"linkbackToHome"                => '<a href="index.php?'.$sids.'">'.$PMF_LANG["msgHome"].'</a>',
	'linkshowInstantResponse'       => '<a href="index.php?'.$sids.'action=instantresponse">'.$PMF_LANG['msgInstantResponse'].'</a>',
	'linkshowSitemap'               => '<a href="index.php?'.$sids.'action=sitemap&amp;lang='.$LANGCODE.'">'.$PMF_LANG['msgSitemap'].'</a>',
	'linkopensearch'                => $systemUri . 'opensearch.php',
	
	));

}

$tpl->includeTemplate('writeContent', 'index');
